class WhitePhotonNuke extends PhotonBlast;

var name damageType;			// type of damage that this projectile does
var float	mpBlastRadius;
var() bool           bDamaged;         // was this blown up via damage?

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local WFCEffect sphere;
   local ExplosionSmall expeffect;

	// draw a pretty explosion
	light = Spawn(None,,, HitLocation);
	if (light != None)
	{
      if (!bDamaged)
         light.RemoteRole = ROLE_None;
		light.size = 8;
		light.LightHue = 128;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}

	expeffect = Spawn(None,,, HitLocation);
   if ((expeffect != None) && (!bDamaged))
      expeffect.RemoteRole = ROLE_None;

	// draw a cool light sphere
	sphere = Spawn(class'Markistan.WFCEffect',,, HitLocation);
	if (sphere != None)
   {
      if (!bDamaged)
         sphere.RemoteRole = ROLE_None;
		sphere.size = blastRadius / 32.0;
   }
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		bIgnoresNanoDefense=True;
	}
}

function Tick(float Deltatime)
{
}

defaultproperties
{
     DamageType=Disintegrated
     mpBlastRadius=2048.000000
     bExplodes=True
     blastRadius=2048.000000
     ItemName="White Photon Nuke"
     Damage=666.000000
     ImpactSound=Sound'DeusExSounds.Weapons.LAMExplode'
     ExplosionDecal=Class'Markistan.PhotonMarkWhite'
     Texture=Texture'Markistan.Effects.WhitePhotonTex'
     Skin=Texture'Markistan.Effects.WhitePhotonTex'
     Mesh=LodMesh'DeusExItems.RocketLAW'
     DrawScale=2.500000
     MultiSkins(0)=Texture'Markistan.Effects.WhitePhotonTex'
     MultiSkins(1)=Texture'Markistan.Effects.WhitePhotonTex'
     MultiSkins(2)=Texture'Markistan.Effects.WhitePhotonTex'
     MultiSkins(3)=Texture'Markistan.Effects.WhitePhotonTex'
     MultiSkins(4)=Texture'Markistan.Effects.WhitePhotonTex'
     MultiSkins(5)=Texture'Markistan.Effects.WhitePhotonTex'
     MultiSkins(6)=Texture'Markistan.Effects.WhitePhotonTex'
     MultiSkins(7)=Texture'Markistan.Effects.WhitePhotonTex'
     SoundRadius=128
     SoundVolume=50
     LightSaturation=240
}
